# @(#) $Id: Makefile.inc 11 2012-01-23 04:04:46Z leres $ (XSE)

##TARGET=	master8

BOARD_TAG=	atmega328

ARDUINO_DIR=	/usr/local/arduino

ARDUINO_LIBS=	SoftwareSerial Wire Wire/utility

AVRDUDE_ARD_PROGRAMMER= usbtiny
#MYARDUINO_PORT = -P usb:/dev/usb:/dev/ugen6.7
MYARDUINO_PORT := $(shell cat PORT 2> /dev/null)

MY_SERIAL := $(shell cat SERIAL 2> /dev/null)

VPATH=	..
CPP_SRCS= multimaster.cpp

LOCAL_CPP_SRCS= \
	$(CPP_SRCS) \
	version.cpp

include /usr/local/arduino/lib/Arduino.mk

CPPFLAGS+= -Wall
CPPFLAGS+= -Werror
CPPFLAGS+= -I..
CPPFLAGS+= ${MASTERDEFINES}

CPPFILES= ${LOCAL_CPP_SRCS}

HFILES= version.h

TAGFILES= ${CPPFILES} ${HFILES}

tags: ${TAGFILES} Makefile
	ctags -wtd ${TAGFILES}

version.cpp::
	@../version.sh -t -V ../VERSION

size: build-cli/${TARGET}.hex
	avr-size build-cli/${TARGET}.elf

defines:
	avr-gcc -mmcu=${MCU} -dM -E - < /dev/null | sort

isp: build-cli/${TARGET}.hex
	/usr/local/bin/avrdude \
	    ${MYARDUINO_PORT} \
	    -B 1 -V \
	    -p ${MCU} \
	    -c ${AVRDUDE_ARD_PROGRAMMER} \
	    -U flash:w:build-cli/${TARGET}.hex:i

hex: build-cli/${TARGET}.hex
	cp -p build-cli/${TARGET}.hex `svnversion`.hex

tip:
	tip ${MY_SERIAL}
