#!/bin/sh
# @(#) $Id: version.sh 16 2012-01-31 07:39:09Z leres $ (XSE)

prog=`basename $0`
usage="usage: ${prog} [-t] [-V VERSION]"


t1="/tmp/${prog}.1.$$"

fn="version.cpp"

trap 'rm -f ${t1}; exit 1' 1 3 15

args=`getopt tV: $*`

if [ $? -ne 0 ]; then
	echo "${usage}" 1>&2
	exit 1
fi

set -- ${args}

decl1="prog_char"
decl2="PROGMEM "
version="VERSION"

for a do
	case "${a}" in

	-t)
		decl1="char"
		decl2=""
		shift
		;;

	-V)
		version="$2"
		shift
		shift
		;;

	--)
		shift
		break
		;;
	esac
done

if [ $# -ne 0 ]; then
	echo "${usage}" 1>&2
	exit 1
fi

version="`cat ${version}`"

svnversion="svnversion"
which ${svnversion} > /dev/null
if [ $? -eq 0 ]; then
	# Use same working directory as VERSION file
	d="`dirname ${version}`"
	svnversion="`cd ${d} && ${svnversion}`"
	case "${svnversion}" in

	Unversioned*)
		;;

	Uncommitted*)
		version="${version}.U"
		;;

	*)
		version="${version}.${svnversion}"
		;;
	esac

fi

(echo "#include \"version.h\""
echo "const ${decl1} version[] ${decl2}= \"${version}\";") > ${t1}

diff ${t1} ${fn} > /dev/null
if [ $? -ne 0 ]; then
	echo "Updating ${fn}"
	cp -p ${t1} ${fn}
fi

rm ${t1}

fgrep ':' ${fn}
if [ $? -eq 0 ]; then
	echo "project is out of date: ${version}" 1>&2
	exit 1
fi
