#!/bin/sh
# @(#) $Id: Exiftimestamps.sh 270 2015-07-05 02:02:49Z leres $ (XSE)
#
# Exiftimestamps - set jpg timestamps using exiftags and touch
#

prog="`basename $0`"
usage="usage: ${prog} [-nv] file ..."

args=`getopt nv $*`

if [ $? -ne 0 ]; then
	echo "${usage}" 1>&2
	exit 1
fi

set -- ${args}

dryrun=0
verbose=0

for a do
	case "${a}" in

	-n)
		dryrun=1
		shift
		;;

	-v)
		verbose=1
		shift
		;;

	--)
		shift
		break
		;;
	esac
done

if [ $# -lt 1 ]; then
	echo "${usage}" 1>&2
	exit 1
fi

# We need the sysv version under Solaris
touch="/usr/bin/touch"
if [ ! -x ${touch} ]; then
	touch="touch"
fi

# Execute (or echo if -n)
execute() {
	cmd="$*"
	if [ ${dryrun} -ne 0 -o ${verbose} -ne 0 ]; then
		echo "+ ${cmd}"
	fi
	if [ ${dryrun} -eq 0 ]; then
		eval "${cmd}"
		return $?
	fi
	return 0
}

gettimestamp()
{
	awk '
	/^Image Created:/ {
		stime = $3 ":" $4
		n = split(stime, a, ":")
		if (n == 6) {
			print a[1] a[2] a[3] a[4] a[5] "." a[6]
			exit
		}
	}
	'
}

# Make sure we have everything we need
for f in exiftags; do
	which ${f} > /dev/null 2>&1
	if [ $? -ne 0 ]; then
		echo "${prog}: Can't find ${f}" 1>&2
		exit 1
	fi
done

while [ $# -gt 0 ]; do
	f="$1"
	shift

	case "`echo ${f} | tr A-Z a-z`" in

	*.jpg)
		# Ok
		;;

	*.jpg-)
		# Ok
		;;

	*)
		echo "${prog}: ${f} unexpected file extension (skipping)"
		status=1
		continue
		;;
	esac

	if [ ! -r ${f} ]; then
		echo "${prog}: Can't find ${f}"
		status=1
		continue
	fi

	#ts="`exiftags ${f} | sed -n -e '^Image Created: \('`"
	ts="`exiftags ${f} | gettimestamp`"
	if [ -z "${ts}" ]; then
		echo "${prog}: ${f}: Didn't find a timestamp"
		continue
	fi

	execute "touch -t ${ts} ${f}"
done

exit ${status}
