/*
 * @(#) $Id: wpbm.c 267 2015-07-04 21:54:44Z leres $ (XSE)
 *
 * Copyright (c) 1999, 2000, 2008, 2009, 2010, 2015
 *	Craig Leres
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code
 * distributions retain the above copyright notice and this paragraph
 * in its entirety, and (2) distributions including binary code include
 * the above copyright notice and this paragraph in its entirety in
 * the documentation or other materials provided with the distribution
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ppm.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "wpbm.h"

int
parsepbm(/* const */ char *image, int *wp, int *hp)
{
	FILE *f;
	pixval maxval;
	int format;

	f = pm_openr(image);
	if (f == NULL)
		return (0);

#ifdef notdef
	/* XXX ignore errors */
	if (tp != NULL && fstat(fileno(f), &sbuf) >= 0)
		*tp = sbuf.st_mtime;
#endif

	ppm_readppminit(f, wp, hp, &maxval, &format);

	(void)fclose(f);
	return (0);
}
