/*
 * @(#) $Id: gif.c 267 2015-07-04 21:54:44Z leres $ (XSE)
 *
 * Copyright (c) 1999, 2000, 2008, 2009, 2010, 2015
 *	Craig Leres
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code
 * distributions retain the above copyright notice and this paragraph
 * in its entirety, and (2) distributions including binary code include
 * the above copyright notice and this paragraph in its entirety in
 * the documentation or other materials provided with the distribution
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "gif.h"

int
parsegif(const char *image, int *wp, int *hp)
{
	struct gifheader *gp;
	int fd, cc;
	struct gifheader gh;

	fd = open(image, O_RDONLY);
	if (fd < 0)
		return (0);

#ifdef notdef
	/* XXX ignore errors */
	if (tp != NULL && fstat(fd, &sbuf) >= 0)
		*tp = sbuf.st_mtime;
#endif

	gp = &gh;
	cc = read(fd, gp, sizeof(*gp));
	(void)close(fd);
	if (cc == sizeof(*gp) &&
	    (strncmp(gp->magic, "GIF87a", sizeof(gp->magic)) == 0 ||
	    strncmp(gp->magic, "GIF89a", sizeof(gp->magic)) == 0)) {
		*wp = GIF_WIDTH(gp);
		*hp = GIF_HEIGHT(gp);
		return (1);
	}
	return (0);
}
