/*
 * @(#) $Id: bmp.c 287 2017-01-21 19:15:36Z leres $ (XSE)
 *
 * Copyright (c) 2000, 2008, 2009, 2010, 2015, 2017
 *	Craig Leres
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code
 * distributions retain the above copyright notice and this paragraph
 * in its entirety, and (2) distributions including binary code include
 * the above copyright notice and this paragraph in its entirety in
 * the documentation or other materials provided with the distribution
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "bmp.h"

/* Forwards */
int
parsebmp(const char *image, int *wp, int *hp, struct timespec *mtimp)
{
	int cc;
	FILE *f;
	struct stat sbuf;
	u_char h[26];

	f = fopen(image, "r");
	if (f == NULL)
		return (0);

	/* XXX ignore errors */
	if (mtimp != NULL && fstat(fileno(f), &sbuf) >= 0)
		*mtimp = sbuf.st_mtim;

	cc = fread(h, 1, sizeof(h), f);
	fclose(f);
	if (cc != sizeof(h) || h[0] != 'B' || h[1] != 'M')
		return (0);

	switch (h[14]) {

	case 12:		/* OS/2 1.x format */
	case 64:		/* OS/2 2.x format */
		*wp = h[18] | (h[19] << 8);
		*hp = h[20] | (h[21] << 8);
		break;

	case 40:		/* Windows 3.x format */
		*wp = h[18] | (h[19] << 8) | (h[20] << 16) | (h[21] << 24);
		*hp = h[22] | (h[23] << 8) | (h[24] << 16) | (h[25] << 24);
		break;

	default:
		return (0);
	}
	return (1);
}
