/*
 * @(#) $Id: png.c 287 2017-01-21 19:15:36Z leres $ (XSE)
 *
 * Copyright (c) 2005, 2006, 2007, 2008, 2009, 2010, 2015, 2017
 *	Craig Leres
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code
 * distributions retain the above copyright notice and this paragraph
 * in its entirety, and (2) distributions including binary code include
 * the above copyright notice and this paragraph in its entirety in
 * the documentation or other materials provided with the distribution
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <netinet/in.h>

#include <stdio.h>
#include <string.h>

#include "cf.h"
#include "png.h"
#include "webindex.h"

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

int
parsepng(const char *image, int *wp, int *hp, struct timespec *mtimp)
{
	int n;
	FILE *f;
	struct stat sbuf;
	char buf[32];
	u_char sig[8] = { 0x89, 'P', 'N', 'G', 13, 10, 26, 10 };

	f = fopen(image, "r");
	if (f == NULL)
		return (0);

	/* XXX ignore errors */
	if (mtimp != NULL && fstat(fileno(f), &sbuf) >= 0)
		*mtimp = sbuf.st_mtim;

	n = fread(buf, 1, sizeof(buf), f);
	fclose(f);
	if (n == 0) {
		fprintf(stderr, "%s: parsepng: zero read %s\n", prog, image);
		return(0);
	} else if (n != sizeof(buf)) {
		fprintf(stderr, "%s: parsepng: short read %s (%d != %d)\n",
		    prog, image, n, (int)sizeof(buf));
		return(0);
	}
	if (memcmp(sig, buf, sizeof(sig)) != 0) {
		fprintf(stderr, "%s: parsepng: bad sig %s\n", prog, image);
		return(0);
	}
	memcpy(wp, buf + 16, sizeof(*wp));
	memcpy(hp, buf + 20, sizeof(*hp));
	*wp = ntohl(*wp);
	*hp = ntohl(*hp);
	return (1);
}
