/* @(#) $Id: cf.h 341 2023-10-06 21:02:44Z leres $ (XSE) */
#ifndef cf_h
#define cf_h

/* Flags */
#define C_NO_IMGSIZE	0x01
#define C_NO_NAME	0x02
#define C_NO_PARENT	0x04
#define C_NO_SIZE	0x08
#define C_NO_DIRDETAIL	0x10
#define C_APPDIRINDEXFN	0x20
#define C_UPCASESUFFIX	0x40
#define C_NO_LOCATION	0x80

/* Icon types */
#define C_AVI_ICON	0x001
#define C_DIR_ICON	0x002
#define C_FILE_ICON	0x004
#define C_FLASH_ICON	0x008
#define C_MP3_ICON	0x010
#define C_PARENT_ICON	0x020
#define C_PDF_ICON	0x040
#define C_QT_ICON	0x080
#define C_REAL_ICON	0x100

/* Sort order types */
#define C_SORT_LEX	0		/* lexical (the default) */
#define C_SORT_REVLEX	1		/* reverse lexical */
#define C_SORT_TIME	2		/* timestamp (oldest first) */
#define C_SORT_REVTIME	3		/* reverse timestamp */

struct section {
	struct section *s_next;
	char *s_file;
	char *s_html;
};

struct list {
	char *l_key;
	char *l_val;
	int l_flags;
};

struct tzlist {
	struct tzlist *t_next;
	time_t t_start;
	char *t_tz;
};

/* Flags */
#define L_REFERENCED	0x01		/* referenced */

struct cf {
	int c_flags;
	int c_icons;			/* icons we're using */
	int c_sort;			/* sort order */
	int c_namelen;			/* hyphenate names longer than this */
	int c_iconsize;			/* max icon width/height */
	int c_imgborder;		/* image border */
	int c_maxrow;			/* max rows per table */
	int c_maxcol;			/* max columns per table */
	int c_tzhours;			/* hours to offset timestamps */

	struct timespec c_tim;		/* unix timestamp of config file */

	/* thumbnail suffix (not dynamic) */
	const char *c_tnsuffix;
	size_t c_tnsuffixlen;

	/* Single line options */
	char *c_css;
	char *c_datefmt;
	char *c_favicon;
	char *c_indexfn;
	char *c_invisiblepat;
	char *c_naildir;
	char *c_target;

	/* Multi-line options */
	char *c_body;
	char *c_head;
	char *c_table;
	char *c_tail;
	char *c_title;
	char *c_tr;

	/* Lists */
	struct list *c_alttext;
	struct list *c_captions;
	struct list *c_invisible;
	struct list *c_thumbnails;
	struct list *c_timestamps;

	/* Section */
	struct section *c_section;

	/* timezone foo */
	struct tzlist *c_tzlist;
};

struct cf *parsecf(const char *);
void freecf(struct cf *);
const char *gettz(struct cf *, time_t);
#endif
