/*
 * @(#) $Id: xbm.c 287 2017-01-21 19:15:36Z leres $ (XSE)
 *
 * Copyright (c) 1999, 2000, 2008, 2009, 2010, 2015, 2017
 *	Craig Leres
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code
 * distributions retain the above copyright notice and this paragraph
 * in its entirety, and (2) distributions including binary code include
 * the above copyright notice and this paragraph in its entirety in
 * the documentation or other materials provided with the distribution
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "xbm.h"

static const char widthstr[] = "width";
static const char heightstr[] = "height";

int
parsexbm(const char *image, int *wp, int *hp, struct timespec *mtimp)
{
	char *cp;
	int fd, cc;
	char buf[1024 + 1];
	struct stat sbuf;

	fd = open(image, O_RDONLY);
	if (fd < 0)
		return (0);

	/* XXX ignore errors */
	if (mtimp != NULL && fstat(fd, &sbuf) >= 0)
		*mtimp = sbuf.st_mtim;

	cp = buf;
	cc = read(fd, cp, sizeof(buf) - 1);
	(void)close(fd);
	if (cc < 0)
		return (0);
	cp[cc] = '\0';

	/* Width */
	cp = strstr(buf, widthstr);
	if (cp == NULL)
		return (0);
	cp += sizeof(widthstr) - 1;
	if (!isspace(*cp))
		return (0);
	do {
		++cp;
	} while (isspace(*cp));
	if (!isdigit(*cp))
		return (0);
	*wp = atoi(cp);

	/* Height */
	cp = strstr(buf, heightstr);
	if (cp == NULL)
		return (0);
	cp += sizeof(heightstr) - 1;
	if (!isspace(*cp))
		return (0);
	do {
		++cp;
	} while (isspace(*cp));
	if (!isdigit(*cp))
		return (0);
	*hp = atoi(cp);

	return (1);
}
