/*
 * @(#) $Id: tiff.c 287 2017-01-21 19:15:36Z leres $ (XSE)
 *
 * Copyright (c) 1999, 2000, 2008, 2009, 2010, 2015, 2017
 *	Craig Leres
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code
 * distributions retain the above copyright notice and this paragraph
 * in its entirety, and (2) distributions including binary code include
 * the above copyright notice and this paragraph in its entirety in
 * the documentation or other materials provided with the distribution
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <stdio.h>
#include <tiffio.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "tiff.h"

int
parsetiff(const char *tiff, int *wp, int *hp, struct timespec *mtimp)
{
	TIFF *t;
	struct stat sbuf;

	t = TIFFOpen(tiff, "r");
	if (t == NULL)
		return (0);

	/* XXX ignore errors */
	if (mtimp != NULL && fstat(TIFFFileno(t), &sbuf) >= 0)
		*mtimp = sbuf.st_mtim;

	(void)TIFFGetField(t, TIFFTAG_IMAGEWIDTH, wp);
	(void)TIFFGetField(t, TIFFTAG_IMAGELENGTH, hp);

	TIFFClose(t);
	return (1);
}
