#!/bin/sh
# @(#) $Id: updatetimestamps.sh 333 2023-09-25 20:36:01Z leres $ (XSE)
#
# updatetimestamps - image the timestamps section of a webindex.conf file
#

prog=`basename $0`

t1=/tmp/${prog}.1.$$
t2=/tmp/${prog}.2.$$

trap 'rm -f ${t1} ${t2}; exit 1' 1 2 3 15

usage()
{
	echo "usage: ${prog} [-c CONF] [directories]" 1>&2
	exit 1
}

args=`getopt c: $*`
if [ $? -ne 0 ]; then
	usage
fi

set -- ${args}

conf="webindex.conf"

for a do
	case "${a}" in

	-c)
		conf="$2"
		shift
		shift
		;;

	--)
		shift
		break
		;;
	esac
done

if [ ! -r ${conf} ]; then
	echo "${prog}":" config ${conf} missing"
	exit 1
fi

if [ $# -gt 0 ]; then
	dirs="$*"
else
	dirs="."
fi

gentimestamps()
{
	if [ $# != 1 ]; then
		echo "usage: gentimestamps DIR" 1>&2
		exit 1
	fi

	ls ${d} | awk '
	BEGIN {
	}
	/\.(jpg|JPG|png|PNG|gif|GIF|mov|MOV|mp3|mpg|mp4|MPG|tif|TIF|txt|TXT)$/ {
		if ($0 ~ /"/) {
			# Silently skip
			next
		}
		files[$0] = 1
		next
	}
	END {
		if (length(files) > 0) {
			cmd = "timestamps"
			for (fn in files) {
				if (fn ~ / /) {
					fn = "\"" fn "\""
				}
				cmd = cmd " " fn
			}
			system(cmd)
		}
	}
	'
}

for d in ${dirs}; do
	if [ ${d} = "." ]; then
		f=${conf}
	else
		f=${d}/${conf}
	fi

	if [ ! -f ${f} ]; then
		echo "${prog}":" ${f} doesn't exist"
		continue
	fi

	gentimestamps ${d} | sort > ${t1}

	(cat ${t1}
	echo ''
	cat ${f}) |
	    awk 'BEGIN {
			sawblank = 0
			eating = 0
			num = 0
		}
		/^$/ {
			if (!sawblank) {
				++sawblank
				next
			}
		}
		{
			if (!sawblank) {
				# accumulate new timestamps
				fn = substr($0, 1, length($0) - (length($NF) + 1))
				stamp[num] = fn
				ts[fn] = $NF
				++num
				next
			}
		}
		/^\.$/ {
			if (eating) {
				if (sawtimestamps)
					for (i = 0; i < num; ++i)
						print stamp[i] "\t" ts[stamp[i]]
				print
				eating = 0
				next
			}
		}
		/^timestamps$/ {
			print
			++eating
			++sawtimestamps
			next
		}
		{
			# If we are not eating timestamps, print
			# If the timestamp is negative, save it
			if (!eating)
				print
			else if ($2 < 0)
				ts[$1] = $2
		}
		END {
			if (!sawtimestamps) {
				print "#"
				print "timestamps"
				for (i = 0; i < num; ++i)
					print stamp[i] "\t" ts[stamp[i]]
				print "."
			}
		}' > ${t2}

	if [ ! -s ${t2} ]; then
		echo "${prog}":" temp file is empty!"
		continue
	fi

	c="diff ${f} ${t2}"
	${c} > ${t1} 2>&1
	tstatus=$?
	if [ ${tstatus} = 0 ]; then
		#echo "${prog}":" ${f} not modified"
		:
	elif [ ! -w ${f} ]; then
		echo ${c}
		cat ${t1}
		echo "${prog}":" ${f} not not writable"
	else
		echo ${c}   
		cat ${t1}

		if [ -f ${f}- ]; then
			c="rm ${f}-"
			echo ${c}
			${c}
		fi

		c="mv ${f} ${f}-"
		echo ${c}
		${c}

		c="cp ${t2} ${f}"
		echo ${c}
		${c}
	fi
done

rm -f ${t1} ${t2}
