#!/bin/sh
# @(#) $Id: Exiftimestamps.sh 297 2019-03-02 22:29:03Z leres $ (XSE)
#
# Exiftimestamps - set jpg timestamps using exiftags and touch
#

prog="`basename $0`"

usage()
{
	echo "usage: ${prog} [-dnv] file ..." 1>&2
	exit 1
}

args=`getopt dnv $*`

if [ $? -ne 0 ]; then
	usage
fi

set -- ${args}

dryrun=0
verbose=0
debug=0

for a do
	case "${a}" in

	-d)
		debug=1
		shift
		;;

	-n)
		dryrun=1
		shift
		;;

	-v)
		verbose=1
		shift
		;;

	--)
		shift
		break
		;;
	esac
done

if [ $# -lt 1 ]; then
	usage
fi

# We need the sysv version under Solaris
touch="/usr/bin/touch"
if [ ! -x ${touch} ]; then
	touch="touch"
fi

# Execute (or echo if -n)
execute() {
	cmd="$*"
	if [ ${dryrun} -ne 0 -o ${verbose} -ne 0 ]; then
		echo "+ ${cmd}"
	fi
	if [ ${dryrun} -eq 0 ]; then
		eval "${cmd}"
		return $?
	fi
	return 0
}

# Make sure we have everything we need
for f in exiftool; do
	which ${f} > /dev/null 2>&1
	if [ $? -ne 0 ]; then
		echo "${prog}: Can't find ${f}" 1>&2
		exit 1
	fi
done

tag=

while [ $# -gt 0 ]; do
	f="$1"
	shift

	case "`echo ${f} | tr A-Z a-z`" in

	*.jpg)
		tag=CreateDate
		;;

	*.jpg-)
		tag=CreateDate
		;;

	*.png)
		tag=DateCreated
		;;

	*.png-)
		tag=DateCreated
		;;

	*)
		echo "${prog}: ${f} unsupported file extension (skipping)" 1>&2
		status=1
		continue
		;;
	esac

	if [ ! -r ${f} ]; then
		echo "${prog}: Can't find ${f}"
		status=1
		continue
	fi

	cmd="exiftool -d %Y%m%d%H%M.%S -${tag} ${f}"
	if [ ${debug} -ne 0 ]; then
		echo "+ ${cmd}" 1>&2
	fi
	ts="`${cmd} | awk '{ print $NF }'`"
	if [ -z "${ts}" ]; then
		echo "${prog}: ${f}: Didn't find a timestamp" 1>&2
		continue
	fi

	execute "touch -t ${ts} ${f}"
done

exit ${status}
