/*
 * @(#) $Id: xwd.c 352 2024-12-28 21:09:42Z leres $ (XSE)
 *
 * Copyright (c) 1999, 2000, 2008, 2009, 2010, 2015, 2017, 2024
 *	Craig Leres
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code
 * distributions retain the above copyright notice and this paragraph
 * in its entirety, and (2) distributions including binary code include
 * the above copyright notice and this paragraph in its entirety in
 * the documentation or other materials provided with the distribution
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "xwd.h"

int
parsexwd(const char *image, int *wp, int *hp, struct timespec *mtimp)
{
	struct xwdheader *xp;
	int fd, cc;
	struct xwdheader xh;
	struct stat sbuf;

	fd = open(image, O_RDONLY);
	if (fd < 0)
		return (0);

	/* XXX ignore errors */
	if (mtimp != NULL && fstat(fd, &sbuf) >= 0)
		*mtimp = sbuf.st_mtim;

	xp = &xh;
	cc = read(fd, xp, sizeof(*xp));
	(void)close(fd);
	if (cc != sizeof(*xp))
		return (0);
	if (xp->v == XWD_VX11) {
		*wp = xp->u.x11.w;
		*hp = xp->u.x11.h;
	} else if (xp->v == XWD_VX10) {
		*wp = xp->u.x10.w;
		*hp = xp->u.x10.h;
	} else if (bs32(xp->v) == XWD_VX11) {
		*wp = bs32(xp->u.x11.w);
		*hp = bs32(xp->u.x11.h);
	} else if (bs32(xp->v) == XWD_VX10) {
		*wp = bs32(xp->u.x10.w);
		*hp = bs32(xp->u.x10.h);
	} else
		return (0);
	return (1);
}

int
bs32(int in)
{
	u_char *up;
	u_char buf[4];
	int out;

	up = (u_char *)&in;
	buf[0] = up[3];
	buf[1] = up[2];
	buf[2] = up[1];
	buf[3] = up[0];
	memmove(&out, buf, sizeof(buf));
	return (out);
}
